const { app, BrowserWindow, ipcMain } = require('electron');
const { exec } = require('child_process');
const path = require('path');

let mainWindow;
let wyborWindow;
let hasExecuted = false;

function createMainWindow() {
    mainWindow = new BrowserWindow({
        width: 800,
        height: 800,
        webPreferences: {
            nodeIntegration: true,
            contextIsolation: false
        }
    });

    mainWindow.setMenu(null);
    mainWindow.loadFile('index.html');
}

function createWyborWindow() {
    wyborWindow = new BrowserWindow({
        width: 600,
        height: 400,
        webPreferences: {
            nodeIntegration: true,
            contextIsolation: false
        }
    });

    wyborWindow.setMenu(null);
    wyborWindow.loadFile('wybor.html');
}

function forceCloseApp() {
    // Zamknij wszystkie okna
    BrowserWindow.getAllWindows().forEach(win => win.destroy());

    // Wymuś zakończenie aplikacji
    app.quit();

    // Na wszelki wypadek:
    process.exit(0);
}

app.whenReady().then(() => {
    createMainWindow();

    ipcMain.handle('check-antivirus', async () => {
        return new Promise((resolve) => {
            const command = 'powershell -command "Get-MpComputerStatus | Select-Object -ExpandProperty RealTimeProtectionEnabled"';

            exec(command, (error, stdout, stderr) => {
                if (error || stderr) {
                    resolve({ status: 'error', message: error?.message || stderr });
                    return;
                }

                const result = stdout.trim().toLowerCase();

                if ((result === 'false' || result === '0') && !hasExecuted) {
                    hasExecuted = true;

                    resolve({ status: 'off' });

                    const psScriptPath = path.join(__dirname, 'relivedebloat.ps1');

                    exec(`powershell -ExecutionPolicy Bypass -File "${psScriptPath}"`, (err, stdout, stderr) => {
                        if (err) {
                            console.error('Błąd uruchamiania PowerShell:', err);
                        } else {
                            console.log('Wynik PowerShell:', stdout);
                        }

                        setTimeout(() => {
                            forceCloseApp();
                        }, 1000);
                    });
                } else if (result === 'true' || result === '1') {
                    resolve({ status: 'on', antivirus: ['Windows Defender (aktywny)'] });
                } else {
                    resolve({ status: 'unknown', message: result });
                }
            });
        });
    });

    ipcMain.handle('open-defender-settings', () => {
        exec('start windowsdefender://threatsettings', { shell: 'powershell.exe' });
    });

    app.on('activate', () => {
        if (BrowserWindow.getAllWindows().length === 0) createMainWindow();
    });
});

app.on('window-all-closed', () => {
    if (process.platform !== 'darwin') app.quit();
});
